#!/usr/bin/env python
"""
Kolorowa wersja gry Snap
"""
import time                 # Na potrzeby dodawania opóźnień
import piface.pfio as pfio  # Biblioteka piface
import os, pygame, sys
import random
import pygame
from pygame.locals import *
pygame.init()
pygame.mixer.quit()
pygame.mixer.init()
pfio.init()         # Inicjowanie biblioteki piface

snapSound = pygame.mixer.Sound("sounds/snap.ogg")
tickSound = pygame.mixer.Sound("sounds/tick.ogg")
applauseSound = pygame.mixer.Sound("sounds/applause.ogg")
dohSound = pygame.mixer.Sound("sounds/doh.ogg")

easyCols = [ 0x3, 0xC, 0xF, 0x30, 0x33, 0x3C, 0x3F ]
intCols = [ 0x3, 0xC, 0xF, 0x30, 0x33, 0x3C, 0x3F,
              0x1, 0x4, 0x5, 0x10, 0x11, 0x14, 0x15]
colours = [ easyCols, intCols ]
level = 0 # 0 = najniższy poziom 2 = najwyższy poziom
playerName = ["Brak", "Gracz niebieski","Gracz czerwony", "Remis"]
countToMatch = 0
roundToPlay = 1 # Numer rundy
maxRound = 3 # Liczba rund do rozegrania
redScore = 0
blueScore = 0

def main():
        global level
        print"Kolorowa wersja gry Snap. Wciśnij Ctrl+C, aby zakończyć."
        il = raw_input ("Podaj poziom trudności - od 1 (niski) do 3 (wysoki) ")
        level = int(il)-1
        lc = random.randint(0,63) # Poprzednio wyświetlony kolor
        while roundToPlay <= maxRound :
            print "Runda ",roundToPlay, " z ",maxRound    
            countToMatch = random.randint(3, 10)
            while countToMatch !=0 : # Powtarzanie do momentu dojścia do kolejki, w której kolor ma być taki sam
                 countToMatch -= 1
                 if countToMatch != 0 : # W ostatniej kolejce nie należy generować nowego koloru
                      c = newColour(lc);  
                 tickSound.play()
                 time.sleep(0.5)
                 pfio.write_output(c)  # Włączenie koloru
                 checkInput(0.8, c, lc)
                 pfio.write_output(0) # Wyłączenie diody
                 checkInput(0.9, c, lc)
                 lc = c # Zapisywanie poprzedniego koloru
        print "Koniec gry"
        if blueScore == redScore :
                print"REMIS!!! "
        else:
                win = 2
                if blueScore > redScore :
                        win = 1
                print"Wygrał ",playerName[win]        
                
              
def newColour(lastColour) :
        nc = lastColour
        if level == 2 : # Najwyższy poziom
                nc ^= 1 << random.randint(0,5) # Zmiana o tylko jeden bit
        else:
             while nc == lastColour : # Powtarzanie do momentu uzyskania nowego koloru
                 nc = colours[level][random.randint(0,len(colours[level])-1)]
        return nc

def checkInput(delay, c, lc) : # Obsługa wciśnięcia przycisku
        nextTime = time.time() + delay
        buttonPress = 0
        while nextTime > time.time() and buttonPress == 0 :
             buttonPress = pfio.read_input() & 3
        if buttonPress != 0 :
                snapSound.play()
                checkResult(buttonPress, c, lc)
                while buttonPress !=0 : # Oczekiwanie na zwolnienie przycisku
                        buttonPress = pfio.read_input() & 3

def checkResult(player, newColour, lastColour) :
        global countToMatch, roundToPlay, blueScore, redScore
        pfio.write_output(0) # Wyłączenie diody
        time.sleep(0.8)
        count = 0 
        print playerName[player]
        if lastColour == newColour :
                print"Tak"
                applauseSound.play()
                roundToPlay += 1
                if player == 1 :
                        blueScore += 1
                else:
                        redScore += 1
        else :
                print"Nie"
                dohSound.play()
        while player !=0 or count < 6: # Powtarzanie do momentu zwolnienia przycisku lub sześciu mignięć
                pfio.write_output(lastColour)
                time.sleep(0.3)
                pfio.write_output(newColour)
                time.sleep(0.3)
                player = pfio.read_input() & 3
                count +=1
        pfio.write_output(0) # Wyłączanie diody
        time.sleep(2)
        countToMatch = random.randint(3, 10)
        
if __name__ == '__main__':
    main()   
